'********************************************************************
'   GenArc01.bas
'   by Tom Nally + April 2002
'   Released as Open Source
'   Made with Liberty Basic Workshop....http://iquizme.0catch.com/lb/
'   Made with Liberty Basic.............http://www.libertybasic.com
'********************************************************************

pi = 4*atn(1)

Dim NLSegs(50)
Dim NLSegs$(50)
Dim xplot(50)
Dim yplot(50)

For i = 1 to 50
    NLSegs(i) = i
    NLSegs$(i) = Str$(NLSegs(i))
Next i

NLSegs          = 20
NLSegs$         = "20"
StartAngleDegs  = 15
StartAngleDegs$ = str$(StartAngleDegs)
EndAngleDegs    = 85
EndAngleDegs$   = str$(EndAngleDegs)
StartAngleRads  = (StartAngleDegs/360)*(2*pi)
StartAngleRads$ = str$(StartAngleRads)
EndAngleRads    = (EndAngleDegs/360)*(2*pi)
EndAngleRads$   = str$(EndAngleRads)
XCenter         = 150
YCenter         = 150
Radius          = 100

    True = 1 : False = 0

[InitColors]
    ForegroundColor$ = "Black"
    BackgroundColor$ = "Buttonface"
    TexteditorColor$ = "White"
    TextboxColor$    = "White"
    ComboboxColor$   = "White"
    ListboxColor$    = "White"

[WindowSetup]
    NoMainWin
    WindowWidth = 556 : WindowHeight = 385
    UpperLeftX = Int((DisplayWidth-WindowWidth)/2)
    UpperLeftY = Int((DisplayHeight-WindowHeight)/2)

[ControlSetup]

Graphicbox  #main.Gbox1, 235, 5, 300, 300
Statictext  #main.statictext1, "X Center:", 90, 10, 55, 20
Statictext  #main.statictext2, "Y Center:", 85, 35, 56, 20
Statictext  #main.statictext3, "Radius:", 100, 60, 45, 20
Statictext  #main.statictext4, "Start Angle (degrees):", 15, 85, 130, 20
Statictext  #main.statictext5, "End Angle (degrees):", 20, 110, 125, 20
Statictext  #main.statictext7, "No. Line Segments:", 25, 135, 118, 20
Statictext  #main.statictext8, "Start Angle (radians):", 12, 260, 128, 20
Statictext  #main.StartAngRads, "<none>", 145, 260, 75, 20
Statictext  #main.statictext10, "End Angle (radians):", 20, 285, 120, 20
Statictext  #main.EndAngRads,   "<none>", 145, 285, 75, 20
Button      #main.DrawArc, "Draw Arc",[DrawArc.click],UL, 115, 180, 105, 50
Button      #main.ClearGBox, "CLR Gr. Box",[ClearGBox.click],UL, 15, 180, 95, 50
Button      #main.button3, "About...",[About.click],UL, 365, 315, 75, 25
Button      #main.Close, "Close",[Close.click],UL, 445, 315, 90, 25
Textbox     #main.txtXcenter, 145, 5, 75, 24
Textbox     #main.txtYcenter, 145, 30, 75, 24
Textbox     #main.txtRadius, 145, 55, 75, 24
Textbox     #main.txtStartAng, 145, 80, 75, 24
Textbox     #main.txtEndAng, 145, 105, 75, 24
Combobox    #main.NLSegs,NLSegs$(,[NLSegs.click], 145, 135, 75, 150

Open "Function GenArc(Xc, Yc, R, StartD, EndD, NLS) - Released as Open Source" For Window As #main

    Print #main, "trapclose [Close.click]"
    Print #main.Gbox1, "down; fill white; flush"
    Print #main, "font arial 10"

    GoSub [Initialize.Controls]

[loop]
    Wait

[quit]
    Close #main : End

[Initialize.Controls]

    print #main.NLSegs, "selectindex 20"
    print #main.txtStartAng, StartAngleDegs$
    print #main.txtEndAng, EndAngleDegs$
    print #main.StartAngRads, StartAngleRads$ 
    print #main.EndAngRads, EndAngleRads$
    Print #main.txtXcenter, str$(XCenter)
    Print #main.txtYcenter, str$(YCenter)
    print #main.txtRadius, str$(Radius)

    Return

[DrawArc.click]
    'Get XCenter and YCenter from the TextBoxes
    Print #main.txtXcenter, "!Contents? XCenter$"
    Print #main.txtYcenter, "!Contents? YCenter$"
    XCenter = val(XCenter$)
    YCenter = val(YCenter$)
    'Get the Radius from the TextBox
    print #main.txtRadius, "!Contents? Radius$"
    Radius = val(Radius$)
    'Get the Start and Eng Angles from the Text boxes
    print #main.txtStartAng, "!Contents? StartAngleDegs$"
    print #main.txtEndAng, "!Contents? EndAngleDegs$"
    StartAngleDegs = val(StartAngleDegs$)
    EndAngleDegs = val(EndAngleDegs$)
    StartAngleRads = (StartAngleDegs/360)*(2*pi)
    StartAngleRads$ = str$(StartAngleRads)
    EndAngleRads = (EndAngleDegs/360)*(2*pi)
    EndAngleRads$ = str$(EndAngleRads)
    print #main.StartAngRads, StartAngleRads$ 
    print #main.EndAngRads, EndAngleRads$ 

    DummyVariable = GenArc(XCenter, YCenter, Radius, StartAngleDegs, EndAngleDegs, NLSegs)


    GoTo [loop]

[ClearGBox.click]

    print #main.Gbox1, "cls"
    Print #main.Gbox1, "down; fill white; flush"

    GoTo [loop]

[About.click]

    notice "About GenArc()" + chr$(13) + _
           "By Tom Nally - April 2002           " + chr$(13) + _
           "Released as Open Source             " + chr$(13) + _
           "+   +   +   +   +   +   +   +   +   +   +   +   " + chr$(13) + _
           "Made With Liberty Basic Workshop    " + chr$(13) + _
           "http://alycesrestaurant.com/        " + chr$(13) + _
           "+   +   +   +   +   +   +   +   +   +   +   +   " + chr$(13) + _
           "Made With Liberty Basic             " + chr$(13) + _
           "http://www.LibertyBasic.com         "

    GoTo [loop]

[Close.click]

    Close #main : End
    GoTo [loop]

[NLSegs.click]
    Print #main.NLSegs, "selection? NLSegs$"
    NLSegs = val(NLSegs$)

    GoTo [loop]



Function GenArc(Xc, Yc, R, StartD, EndD, NLS)
    pi = 4*atn(1)
    StartR = (StartD/360)*(2*pi)
    EndR   = (EndD/360)*(2*pi)
    ArcElement = (EndR - StartR) / NLS

    xplot(0) = Xc + R * cos(StartR)
    yplot(0) = Yc - R * sin(StartR)

    For i = 1 to NLS
        xplot(i) = Xc + R * cos(StartR + i*ArcElement)
        yplot(i) = Yc - R * sin(StartR + i*ArcElement)
    Next i

    'Draw a small cross at the arc center
    print #main.Gbox1, "line " + str$(Xc - 5) + " " + str$(Yc)+ " " + str$(Xc + 5) + " " + str$(Yc)
    print #main.Gbox1, "line " + str$(Xc) + " " + str$(Yc + 5)+ " "  + str$(Xc) + " " + str$(Yc - 5)

    'Plot the Arc

    For i = 1 to NLS
        ArcString$ = Str$(xplot(i-1)) + " " + _
                     Str$(yplot(i-1)) + " " + _
                     Str$(xplot(i)) + " " + _
                     Str$(yplot(i))
        print #main.Gbox1, "line " + ArcString$
    next i



End Function




